using System;
using System.Text;
using System.Management.Automation;
using System.Management.Automation.Provider;
using System.Management;

namespace de.ITVisions.PowerShell
{

 /// <summary>
 /// This class implements the Get-Processor cmdlet
 /// </summary>
 [Cmdlet(VerbsCommon.Get, "Disk1")]
 public class GetDiskCommand1 : PSCmdlet
 {

  protected override void BeginProcessing()
  {
  }

  protected override void ProcessRecord()
  {
   string ABFRAGE = "Select * from Win32_Logicaldisk";
   string Computer = ".";

   System.Management.ManagementObjectCollection DiskMenge;
   ManagementScope ms = new ManagementScope("\\\\" + Computer + "\\root\\cimv2");
   ObjectQuery oq = new ObjectQuery(ABFRAGE);
   System.Management.ManagementObjectSearcher suche = new System.Management.ManagementObjectSearcher(ms, oq);
   DiskMenge = suche.Get();

   // Objekte einzeln zurckgeben
   this.WriteObject(DiskMenge, true);

   // Alternative
   //foreach (ManagementObject Disk in DiskMenge)
   //{
   // this.WriteObject(Disk);
   //}
  }

  protected override void StopProcessing()
  {
  }

 }
}
